#define FClk 20000
#define PORT PORTB
#define DDR  DDRB
#define PIN  PINB
#define BitNum 0

/*
    :
	    0 -  
		1 - 
		2 - 
		3 - 
*/

.cseg

   //  3 

#define  WaitCount r26
#define  BitCount  r27
#define  Res0      r28
#define  Cmd       r29
#define  ByteCnt   r16
#define  KS        r17 

.global _Dbg

_Dbg: //cbi PORTB, 1   
    cbi PORT, BitNum 
	push WaitCount
	in   WaitCount, SREG
    sbi DDR, BitNum //    (5 ..)
    
	push WaitCount

	clr  WaitCount

WaitSendItr: //    ~ 1/10 .
    dec WaitCount
	brne WaitSendItr

    cbi DDR, BitNum //    (    )

    push BitCount
	push Res0
	push Cmd     
	push ByteCnt
    push KS

Cikl: //       -   .    
	clt // 
    rcall ReadWrite
    mov   Cmd, Res0

	rcall ReadWrite
    mov r30, Res0

	rcall ReadWrite
    mov r31, Res0

	rcall ReadWrite
	
	cpi   Cmd, 1
	brcs  CmdContinue //   0

	breq  CmdWrite //   1	

M1: ldi   ByteCnt, 8
    set // 
    ldi  KS, 0xAA
ReadCikl:
    ld   Res0, Z+ 
	add   KS, Res0
    rcall ReadWrite
	dec   ByteCnt
	brne  ReadCikl

	mov   Res0, KS
	rcall ReadWrite

    rjmp Cikl

CmdWrite:
    st Z, Res0
    rjmp Cikl

CmdContinue:
    set // 
	ldi Res0, 0x55
	rcall ReadWrite

Exit: 
    //sbi  PORTB, 1   
    pop  KS
	pop  ByteCnt
	pop  Cmd
	pop  Res0
	pop  BitCount
	pop  WaitCount
	out  SREG, WaitCount
	pop  WaitCount
	ret
	

//-------------------------       -   --------------------

ReadWrite:
/*
    :  T = 0
	          
*/    
    ldi  BitCount, 8
    

//-------------------------        --------------------------------------------
Wait0:
    sbic PIN, BitNum
	rjmp Wait0

    //sbic PinB, 0
	//rjmp Wait0

	

//-------------------------         -----------------------------------------------

    
Wait1: 
    
    sbis PIN, BitNum
	rjmp Wait1
	
    //sbis PinB, 0
	//rjmp Wait1

	
//----------------------------------     -  ,      20 ..----------------
    lsr Res0  //2  ( 4 ..)
	brtc Reading

    brcs BitCikl   //  ,       

    sbi  DDR, BitNum   //   0


//-------------------------------------    65  96 ..  20   ----------------------


     ldi WaitCount, (65 * FClk - 140000) / 60000 + 1
SignalWait:
     dec WaitCount
     brne SignalWait
	
	cbi  DDR, BitNum   //  1 
    
	rjmp BitCikl

//-------------------------         ------------------------------------------
Reading:
    
	ldi WaitCount, (79 * FClk - 120000) / 60000 + 1// 73  105

EndReadingWait:
	dec WaitCount
    brne EndReadingWait 

	sbic PIN, BitNum
    ori  Res0, 0x80

//-------------------------              ----------------------------
BitCikl:
    dec BitCount
    brne Wait0

//-------------------------    -    1  -------------------------

    //ori Res0, 1
	//out PORTC, Res0
m0:
	sbis PIN, BitNum
	rjmp m0

	ret 
